; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;--|AI Activation|----------------------------------------------------------

[Command]
name = "AI1"
command = U,U,U,U,F,B,B,F,a,b,a,c,a,b
time = 1

[Command]
name = "AI2"
command = U,U,U,D,F,B,B,F,b,a,a,a,a,a,a
time = 1

[Command]
name = "AI3"
command = U,U,D,D,F,B,B,F,c,c,c,c,c,c,c
time = 1

[Command]
name = "AI4"
command = U,D,D,D,F,B,B,F,x,b,b,b,
time = 1

[Command]
name = "AI5"
command = D,D,D,D,F,B,B,F,y,a,a,c,b
time = 1

[Command]
name = "AI6"
command = D,D,D,U,F,B,B,F,z,z,z,z,z,x,a
time = 1

[Command]
name = "AI7"
command = D,D,U,U,F,B,B,F,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 1

[Command]
name = "AI8"
command = D,U,U,U,F,B,B,F,z,z,z,z,z,z,z,x,x,x,x,x
time = 1

[Command]
name = "AI9"
command = U,D,U,U,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,a,a,a,a,a,a,a
time = 1

[Command]
name = "AI10"
command = U,U,D,U,F,B,B,F,c,c,c,c,c,a,a,a,z,z,z,x,x,x,x
time = 1

[Command]
name = "AI11"
command = D,U,U,D,F,B,B,F,b,b,b,b,b,b,B,B,B,B,B,B,B,B,B,B,B,
time = 1

[Command]
name = "AI12"
command = U,D,D,U,F,B,B,F,D,D,D,D,D,D,D,D,D,D,D,D,
time = 1

[Command]
name = "AI13"
command = D,U,D,U,F,B,B,F,U,U,U,U,U,U,U,U,U,U,U,U,U,D
time = 1

[Command]
name = "AI14"
command = U,D,U,D,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z
time = 1

[Command]
name = "AI15"
command = F,F,F,F,F,B,B,F,D,D,D,D,D,D,D,x,x,x,x,x,x,x,x,z,z,z,z,z
time = 1

[Command]
name = "AI16"
command = B,B,B,B,F,B,B,F,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z
time = 1

[Command]
name = "AI17"
command = F,B,F,F,F,B,B,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,U,U,U,U,U,U,U,U,U,U,U,U,F
time = 1

[Command]
name = "AI18"
command = F,F,B,F,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 1

[Command]
name = "AI19"
command = B,F,F,F,F,B,B,F,F,F,F,F,F,F,F,F,F,F,F,F,U,U,U,U,U,U,U,U,U,U,U,U,U,D,D,D,D,D,D,D,B,B,B
time = 1

[Command]
name = "AI20"
command = F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F
time = 1

[Command]
name = "AI21"
command = F,B,B,F,F,B,B,F,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B
time = 1

[Command]
name = "AI22"
command = B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F
time = 1

[Command]
name = "AI23"
command = F,B,F,B,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 1

[Command]
name = "AI24"
command = B,F,B,F,F,B,B,F,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z
time = 1

[Command]
name = "AI25"
command = D,F,D,F,F,B,B,F
time = 1

[Command]
name = "AI26"
command = D,B,D,B,F,B,B,F
time = 1

[Command]
name = "AI27"
command = D,B,D,F,F,B,B,F
time = 1

[Command]
name = "AI28"
command = D,F,D,B,F,B,B,F
time = 1

[Command]
name = "AI29"
command = U,F,D,B,F,B,B,F
time = 1

[Command]
name = "AI30"
command = U,B,D,F,F,B,B,F
time = 1

;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;
[Command]
name = "Twister"
command = ~D, DF, F, DF, F, b
time = 20

[Command]
name = "Super Slam"
command = ~D, DF, F, DF, F, y
time = 20

[Command]
name = "Dark Pulse"   ;Same name as above
command = ~D, DF, F, DF, F, a
time = 20


;-| Special Motions |------------------------------------------------------
[Command]
name = "Weak Pulse"
command = ~D, DF, F, x

[Command]
name = "Weak Pulse"
command = ~D, DF, F, y

[Command]
name = "Fast Hack"
command = ~D, DB, B, x

[Command]
name = "Fast Hack"
command = ~D, DB, B, y

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery";Required (do not remove)
command = y+z
time = 1

[Command]
name = "recovery";Required (do not remove)
command = z+a
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a+b
time = 1

[Command]
name = "recovery";Required (do not remove)
command = b+c
time = 1

[Command]
name = "recovery";Required (do not remove)
command = c+x
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a+x
time = 1

[Command]
name = "recovery";Required (do not remove)
command = b+y
time = 1

[Command]
name = "recovery";Required (do not remove)
command = c+z
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------

[Command]
name = "2p"
command = a
time = 1

[Command]
name = "2p"
command = b
time = 1

[Command]
name = "2p"
command = x
time = 1

[Command]
name = "2p"
command = y
time = 1

[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holdc"
command = /$c
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]
;==================================================================
[State -1, Dark Twister]
type = ChangeState
value = 3000
triggerall = command = "Twister"
triggerall = power >= 3000
trigger1 = statetype = S
trigger1 = NumHelper < 80
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = time > 188
trigger2 = stateno!= [3000,3000]
trigger2 = movecontact

[State -1, Dark Twister AI]
type = ChangeState
value = 3000
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 16
triggerall = random < 128
triggerall = statetype != A
triggerall = power >= 3000
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 188

;==================================================================
[State -1, Dark Pulse]
type = ChangeState
value = 4000
triggerall = command = "Dark Pulse"
triggerall = power >= 1500
trigger1 = statetype = S
trigger1 = NumHelper < 80
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = time > 188
trigger2 = stateno!= [4000,4000]

[State -1, Dark Pulse AI]
type = ChangeState
value = 4000
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 16
triggerall = random < 128
triggerall = statetype != A
triggerall = power >= 1500
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 188


;==================================================================
[State -1, Super Slam]
type = ChangeState
value = 2100
triggerall = command = "Super Slam"
triggerall = power >= 3000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = time > 188
trigger2 = stateno!= [2100,2100]

[State -1, Super Slam AI]
type = ChangeState
value = 2100
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 8
triggerall = random < 28
triggerall = statetype != A
triggerall = power >= 3000
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time > 88
trigger2 = hitdefattr = SC, NA, SA

;===========================================================================
;This is not a move, but it sets up var(1) to be 1 if conditions are right
;for a combo into a special move (used below).
;Since a lot of special moves rely on the same conditions, this reduces
;redundant logic.
[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(1) = 0

[State -1, Combo condition Check]
type = VarSet
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = stateno != 440 ;Except for sweep kick
trigger2 = movecontact
var(1) = 1

;==========================================================================
; AI Activation
[State -1, AI On]
type = VarSet
triggerall = RoundState = 2
trigger1 = command = "AI1"
trigger2 = command = "AI2"
trigger3 = command = "AI3"
trigger4 = command = "AI4"
trigger5 = command = "AI5"
trigger6 = command = "AI6"
trigger7 = command = "AI7"
trigger8 = command = "AI8"
trigger9 = command = "AI9"
trigger10 = command = "AI10"
trigger11 = command = "AI11"
trigger12 = command = "AI12"
trigger13 = command = "AI13"
trigger14 = command = "AI14"
trigger15 = command = "AI15"
trigger16 = command = "AI16"
trigger17 = command = "AI17"
trigger18 = command = "AI18"
trigger19 = command = "AI19"
trigger20 = command = "AI20"
trigger21 = command = "AI21"
trigger22 = command = "AI22"
trigger23 = command = "AI23"
trigger24 = command = "AI24"
trigger25 = command = "AI25"
trigger26 = command = "AI26"
trigger27 = command = "AI27"
trigger28 = command = "AI28"
trigger29 = command = "AI29"
trigger30 = command = "AI30"
var(58) = 1

[State -1, AI Off]
type = VarSet
triggerall = !Win
trigger1 = !alive
trigger2 = roundstate <= 1
trigger3 = roundstate >= 3
var(58) = 0

;---------------------------------------------------------------------------
;Weak Pulse
[State -1, Weak Pulse]
type = ChangeState
value = 1000
triggerall = command = "Weak Pulse"
triggerall = power >= 880
trigger1 = var(1)

[State -1, Dark Pulse AI]
type = ChangeState
value = 1000
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 16
triggerall = random < 128
triggerall = statetype != A
triggerall = power >= 880
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 188

;==========================================================================
;Fast Hack
[State -1, Fast Hack]
type = ChangeState
value = 2200
triggerall = command = "Fast Hack"
triggerall = power >= 1500
trigger1 = var(1)

[State -1, Dark Pulse AI]
type = ChangeState
value = 2200
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 16
triggerall = random < 128
triggerall = statetype != A
triggerall = power >= 1500
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 188

;===========================================================================
; Counter
[State -1, Counter]
type = ChangeState
value = 900
triggerall = power >= 10
triggerall = command = "2p"
triggerall = statetype != A
trigger1 = !var(0)
trigger1 = stateno = 150
trigger2 = stateno = 151
trigger3 = stateno = 152
trigger4 = stateno = 153

;----------------------------------------------------------------
[State -1, Counter AI]
type = ChangeState
triggerall = !win
triggerall = var(58) = 1
triggerall = power >= 10
triggerall = StateType = S
triggerall = p2movetype = A
triggerall = p2bodydist x <= 50
trigger1 = stateno = 150
trigger2 = stateno = 151
trigger3 = stateno = 152
trigger4 = stateno = 153
value = 900

;--------------------------------------------------------------
[State -1, Guard AI]
type = ChangeState
triggerall = !win
triggerall = var(58) = 1
triggerall = StateType = S
trigger1 = p2movetype = A
trigger1 = movetype != A
trigger1 = ctrl
value = 120

;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
;light punch
[state -1,atk1]
type = changestate
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = ctrl
trigger1 = statetype = S
value = 200

[State -1,atk1 AI]
type = ChangeState
value = 200
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 20
triggerall = random < 23
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA

;---------------------------------------------------------------------------
;light punch
[state -1,atk2]
type = changestate
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = ctrl
trigger1 = statetype = S
value = 201
trigger2 = anim = 200
trigger2 = animelemtime (1) > 0

[State -1,atk2 AI]
type = ChangeState
value = 201
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 20
triggerall = random < 23
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = anim = 200
trigger2 = animelemtime (1) > 0

;---------------------------------------------------------------------------
;light punch
[state -1,atk3]
type = changestate
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = ctrl
trigger1 = statetype = S
value = 202
trigger2 = anim = 201
trigger2 = animelemtime (3) > 0

[State -1,atk3 AI]
type = ChangeState
value = 202
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 20
triggerall = random < 23
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = anim = 201
trigger2 = animelemtime (3) > 0

;---------------------------------------------------------------------------
;light punch
[state -1,atk4]
type = changestate
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = ctrl
trigger1 = statetype = S
value = 203
trigger2 = anim = 202
trigger2 = animelemtime (1) > 0

[State -1,atk4 AI]
type = ChangeState
value = 203
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 20
triggerall = random < 23
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = anim = 202
trigger2 = animelemtime (1) > 0

;---------------------------------------------------------------------------
[state -1,H atk1]
type = changestate
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = ctrl
trigger1 = statetype = S
value = 240

[State -1,H atk1 AI]
type = ChangeState
value = 240
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 44
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time = 23

;---------------------------------------------------------------------------
[state -1,H atk2]
type = changestate
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = ctrl
trigger1 = statetype = S
value = 241
trigger2 = anim = 240
trigger2 = animelemtime (6) > 0

[State -1,H atk2 AI]
type = ChangeState
value = 241
triggerall = (roundstate = 2) && (var(58))
triggerall = anim = 240
triggerall = random < 44
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time = 23
trigger2 = animelemtime (6) > 0

;---------------------------------------------------------------------------
;Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 12
trigger3 = (stateno = 230) && time > 16

[State -1, Stand Strong Punch AI]
type = ChangeState
value = 210
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random <12
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 20

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Stand Light Kick AI]
type = ChangeState
value = 230
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 35
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 24

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) && time > 38

[State -1, Crouching Light Punch AI]
type = ChangeState
value = 400
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 77
triggerall = statetype != A
triggerall = P2statetype != C
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 34
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

[State -1, Crouching Light Punch AI]
type = ChangeState
value = 410
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 77
triggerall = statetype != A
triggerall = P2statetype != C
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 34
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) && time > 54

[State -1, Crouching Light Punch AI]
type = ChangeState
value = 430
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 77
triggerall = statetype != A
triggerall = P2statetype != C
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 34
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

[State -1, Crouching Light Punch AI]
type = ChangeState
value = 440
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 77
triggerall = statetype != A
triggerall = P2statetype != C
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 34
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
trigger3 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger3 = stateno = 1350 ;Air blocking

[State -1, Jump Light KickAI]
type = ChangeState
value = 600
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 43
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno = 600
trigger2 = time >= 30
trigger3 = stateno = 1350

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 1350 ;Air blocking

[State -1, Jump Strong KickAI]
type = ChangeState
value = 630
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 44
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno = 600 || stateno = 630
trigger3 = stateno = 1350


;--------------------------------------------------------------------------
;Charge
[State -1, Charge]
type = ChangeState
value = 3300
triggerall = command = "holdc"
triggerall = power < 3000
trigger1 = Statetype = S
trigger1 = ctrl

;----------------------------------------------------------------------------
;Charge Cancel
[State -1, Charge Cancel]
type = ChangeState
value = 3301
trigger1 = command != "holdc"
trigger2 = power = 3000
triggerall = stateno = 3300

;-----------------------------------------------------------------------
; AI: Charge Cancel
[State -1, AI: Charge Cancel]
type = ChangeState
value = 3301
triggerall = (roundstate = 2) && (var(58))
triggerall = stateno != 3301
triggerall = stateno = 3300
trigger1 = statetype = S
trigger1 = command != "holdc"
trigger1 = random < 44
trigger2 = p2movetype = A
trigger3 = power = 3000

